#pragma once

#include "functions.h"

class mlp
{
private:
	int nInputs, nOutputs;
public:
	gsl_vector *neurons;
	gsl_matrix **W;
	activ_function *f;
	bool softmax;
	gsl_matrix *activationHidden;
	
	mlp(gsl_vector *neurons, activ_function *act_f, bool softmax);
	~mlp(void);
	
	gsl_matrix *runNetwork(gsl_matrix *inputs);
	gsl_vector *runNetwork(gsl_vector *input);
	//gsl_vector *runNetwork(gsl_vector *input);
	//gsl_matrix *runNetwork2(gsl_matrix *inputs);

	void trainNetwork(gsl_matrix *inputs, gsl_matrix *desired, double alpha);
	void mlp::trainNetwork(gsl_vector *input, gsl_vector *desired, double alpha);
	//void trainNetwork(gsl_vector *input, gsl_vector *desired, double alpha);

    //void trainNetwork2(gsl_matrix *inputs, gsl_matrix *desired, double alpha);
	double compute_error(gsl_matrix *desired, gsl_matrix *output);

	void saveNetwork(char *path);
	void loadNetwork(char *path);
};
